<?php

/**
 * Example: PaymentMethod request model
 *
 * @author    Payrexx Development <info@payrexx.com>
 * @copyright Payrexx AG
 * @since     v1.7.5
 */

use Payrexx\Models\Request\PaymentMethod;
use Payrexx\Payrexx;
use Payrexx\PayrexxException;

spl_autoload_register(function ($class) {
    $root = dirname(__DIR__);
    $classFile = $root . '/lib/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($classFile)) {
        require_once $classFile;
    }
});

// $instanceName is a part of the url where you access your payrexx installation.
// https://{$instanceName}.payrexx.com
$instanceName = 'YOUR_INSTANCE_NAME';

// $secret is the payrexx secret for the communication between the applications
// if you think someone got your secret, just regenerate it in the payrexx administration
$secret = 'YOUR_SECRET';

$payrexx = new Payrexx($instanceName, $secret);

$paymentMethod = new PaymentMethod();
$paymentMethod->setId('visa');
// $paymentMethod->setFilterCurrency('CHF');
// $paymentMethod->setFilterPaymentType('one-time');
// $paymentMethod->setFilterPsp(36);

try {
    $response = $payrexx->getOne($paymentMethod);
    echo '<pre>';
    var_dump($response);
    echo '</pre>';
    exit();
} catch (PayrexxException $e) {
    print $e->getMessage();
}
