@extends('layouts.user')
@section('content')
    <h2 class="title-bar">
        {{!empty($recovery) ?__('Recovery Boats') : __("Manage Boats")}}
        @if(Auth::user()->hasPermission('boat_create') && empty($recovery))
            <a href="{{ route("boat.vendor.create") }}" class="btn-change-password">{{__("Add Boat")}}</a>
        @endif
    </h2>
    @include('admin.message')
    @if($rows->total() > 0)
        <div class="bc-list-item">
            <div class="bc-pagination">
                <span class="count-string">{{ __("Showing :from - :to of :total Boats",["from"=>$rows->firstItem(),"to"=>$rows->lastItem(),"total"=>$rows->total()]) }}</span>
                {{$rows->appends(request()->query())->links()}}
            </div>
            <div class="list-item">
                <div class="row">
                    @foreach($rows as $row)
                        <div class="col-md-12">
                            @include('Boat::frontend.manageBoat.loop-list')
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="bc-pagination">
                <span class="count-string">{{ __("Showing :from - :to of :total Boats",["from"=>$rows->firstItem(),"to"=>$rows->lastItem(),"total"=>$rows->total()]) }}</span>
                {{$rows->appends(request()->query())->links()}}
            </div>
        </div>
    @else
        {{__("No Boat")}}
    @endif
@endsection
