<?php

namespace Pro\Support;

use Modules\Core\Helpers\AdminMenuManager;
use Modules\ModuleServiceProvider;
use Modules\User\Helpers\PermissionHelper;

class ModuleProvider extends ModuleServiceProvider
{
    public static $isPro = true;

    public function boot()
    {
        $this->loadMigrationsFrom(__DIR__ . '/Database/Migrations');
        $this->mergeConfigFrom(__DIR__ . '/Configs/config.php', 'support');
        PermissionHelper::add([
            'support_topic_view',
            'support_topic_create',
            'support_topic_update',
            'support_topic_delete',

            'support_topic_category',

            // Tickets
            'support_ticket_view',
            'support_ticket_create',
            'support_ticket_update',
            'support_ticket_delete',
            'support_ticket_reply',
            'support_ticket_category',
            'support_ticket_manage',
        ]);
        $this->loadViewsFrom(__DIR__ . '/Views', 'Support');

        AdminMenuManager::register_group('support', __("Support Center"), 160);

    }

    public function register()
    {
        parent::register(); // TODO: Change the autogenerated stub
        $this->app->register(RouterServiceProvider::class);
    }

    public static function getAdminMenu()
    {
        return [
            'ticket' => [
                "position"   => 10,
                'url'        => route('support.admin.ticket.index'),
                'title'      => __("Tickets"),
                'icon'       => 'ion-md-bookmarks',
                'permission' => 'support_ticket_view',
                'group'      => 'support',
                'children'   => [
                    'view' => [
                        'url'        => route('support.admin.ticket.index'),
                        'title'      => __("All Tickets"),
                        'permission' => 'support_ticket_view',
                    ],
                    'cat'  => [
                        'url'        => route('support.admin.ticket.category.index'),
                        'title'      => __("Categories"),
                        'permission' => 'support_ticket_manage',
                    ],
                ]
            ],
            'topic'  => [
                "position"   => 10,
                'url'        => route('support.admin.topic.index'),
                'title'      => __("Topics"),
                'icon'       => 'ion-md-bookmarks',
                'permission' => 'support_topic_view',
                'group'      => 'support',
                'children'   => [
                    'view'   => [
                        'url'        => route('support.admin.topic.index'),
                        'title'      => __("All Topics"),
                        'permission' => 'support_topic_view',
                    ],
                    'create' => [
                        'url'        => route('support.admin.topic.create'),
                        'title'      => __("Add Topic"),
                        'permission' => 'support_topic_create',
                    ],
                    'cat'    => [
                        'url'        => route('support.admin.topic.category.index'),
                        'title'      => __("Categories"),
                        'permission' => 'support_topic_create',
                    ],
                    'tag'    => [
                        'url'        => route('support.admin.topic.tag.index'),
                        'title'      => __("Tags"),
                        'permission' => 'support_topic_create',
                    ],
                ]
            ],
        ];
    }

    public static function getUserMenu()
    {
        if (!isPro()) return [];
        return [
            'support' => [
                'url'   => route('support.index'),
                'title' => __("Support Center"),
            ]
        ];
    }
}
