<?php

namespace Pro\Ai;

use Modules\ModuleServiceProvider;
use Modules\User\Helpers\PermissionHelper;
use Pro\Ai\Drivers\AiDriver;
use Pro\Ai\Drivers\OpenAi;

class ModuleProvider extends ModuleServiceProvider
{

    public function boot()
    {
        $this->loadViewsFrom(__DIR__ . '/Views', 'Ai');

        $this->mergeConfigFrom(__DIR__ . '/Configs/config.php', 'ai');

        $this->loadRoutesFrom(__DIR__ . '/Routes/web.php');

        PermissionHelper::add([
            "ai_text_generate"
        ]);

        add_action('ADMIN_JS_STACK', [$this, '__addJs']);

        $this->app->singleton(AiDriver::class, function () {
            $settings = config('ai.providers');
            $default = config('ai.default');
            if (empty($settings[$default])) {
                throw new \Exception("AI Driver not found");
            }
            return new OpenAi($settings[$default]);
        });
    }


    public function __addJs()
    {
        echo view("Ai::frontend.text-generate");
    }
}
