<?php
namespace Modules\Tour\Controllers;

use ICal\ICal;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Modules\Booking\Models\Booking;
use Modules\FrontendController;
use Modules\Tour\Models\Tour;
use Modules\Tour\Models\TourDate;

class AvailabilityController extends FrontendController
{
    protected $tourClass;
    /**
     * @var TourDate
     */
    protected $tourDateClass;
    /**
     * @var Booking
     */
    protected $bookingClass;
    protected $indexView = 'Tour::frontend.user.availability';

    public function __construct()
    {
        parent::__construct();
        $this->tourClass = Tour::class;
        $this->tourDateClass = TourDate::class;
        $this->bookingClass = Booking::class;
    }

    public function callAction($method, $parameters)
    {
        if (setting_item('tour_disable')) {
            return redirect('/');
        }
        return parent::callAction($method, $parameters); // TODO: Change the autogenerated stub
    }

    public function index(Request $request)
    {
        $this->checkPermission('tour_create');
        $q = $this->tourClass::query();
        if ($request->query('s')) {
            $q->where('title', 'like', '%' . $request->query('s') . '%');
        }
        if (!$this->hasPermission('tour_manage_others')) {
            $q->where('author_id', $this->currentUser()->id);
        }
        $q->orderBy('bc_tours.id', 'desc');
        $rows = $q->paginate(15);
        $current_month = strtotime(date('Y-m-01', time()));
        if ($request->query('month')) {
            $date = date_create_from_format('m-Y', $request->query('month'));
            if (!$date) {
                $current_month = time();
            } else {
                $current_month = $date->getTimestamp();
            }
        }
        $breadcrumbs = [
            [
                'name' => __('Tours'),
                'url'  => route('tour.vendor.index')
            ],
            [
                'name'  => __('Availability'),
                'class' => 'active'
            ],
        ];
        $page_title = __('Tours Availability');
        return view($this->indexView, compact('rows', 'breadcrumbs', 'current_month', 'page_title', 'request'));
    }

    public function loadDates(Request $request)
    {
        $rules = [
            'id'    => 'required',
            'start' => 'required',
            'end'   => 'required',
        ];
        $validator = \Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendError($validator->errors());
        }
        $tour = $this->tourClass::find($request->query('id'));
        if (empty($tour)) {
            return $this->sendError(__('Tour not found'));
        }
        $query = new $this->tourDateClass();
        $allDates = $query->loadDates( date('Y-m-d', strtotime($request->query('start'))) , date('Y-m-d', strtotime($request->query('end'))) , $tour , $request->query('for_single'));
        return response()->json($allDates);
    }

    public function store(Request $request)
    {

        $request->validate([
            'target_id'  => 'required',
            'start_date' => 'required',
            'end_date'   => 'required'
        ]);
        $tour = $this->tourClass::find($request->input('target_id'));
        $target_id = $request->input('target_id');
        if (empty($tour)) {
            return $this->sendError(__('Tour not found'));
        }
        if (!$this->hasPermission('tour_manage_others')) {
            if ($tour->author_id != Auth::id()) {
                return $this->sendError("You do not have permission to access it");
            }
        }
        $dayOfWeek =$request->input("day_of_week_select",[]);
        $postData = $request->input();
        if (!empty($person_types = $postData['person_types']) and is_array($person_types)) {
            foreach ($person_types as &$item) {
                $item['display_price'] = format_money($item['price']);
            }
            $postData['person_types'] = $person_types;
        } else {
            $postData['person_types'] = null;
        }
        $period = periodDate($request->input('start_date'),$request->input('end_date'));
        foreach ($period as $dt){
            $date = $this->tourDateClass::where('start_date', $dt->format('Y-m-d'))->where('target_id', $target_id)->first();
            if (empty($date)) {
                $date = new $this->tourDateClass();
                $date->target_id = $target_id;
            }
            $postData['start_date'] = $dt->format('Y-m-d H:i:s');
            $postData['end_date'] = $dt->format('Y-m-d H:i:s');
            $date->fillByAttr([
                'start_date',
                'end_date',
                'price',
                'max_guests',
                'active',
                'person_types'
            ], $postData);
            if(empty($dayOfWeek)){
                $date->save();
            }elseif(in_array(date('N', strtotime($dt->format('Y-m-d H:i:s')) ),$dayOfWeek)){
                $date->save();
            }
        }
        return $this->sendSuccess([], __("Update Success"));
    }
}
