<?php
namespace Modules\Tour\Blocks;

use Modules\Template\Blocks\BaseBlock;

use Modules\Media\Helpers\FileHelper;

use Modules\Tour\Models\TourCategory;

class BoxCategoryTour extends BaseBlock
{
    public $title;
    public $desc;
    public $list_item = [];


    public function getOptions(){
        return [
            'settings' => [
                [
                    'id'        => 'title',
                    'type'      => 'input',
                    'inputType' => 'text',
                    'label'     => __('Title')
                ],
                [
                    'id'        => 'desc',
                    'type'      => 'input',
                    'inputType' => 'text',
                    'label'     => __('Desc')
                ],
                [
                    'id'          => 'list_item',
                    'type'        => 'listItem',
                    'label'       => __('List Item(s)'),
                    'title_field' => 'title',
                    'settings'    => [
                        [
                            'id'      => 'category_id',
                            'type'    => 'select2',
                            'label'   => __('Select Category'),
                            'select2' => [
                                'ajax'  => [
                                    'url'      => route('tour.admin.category.category.getForSelect2'),
                                    'dataType' => 'json'
                                ],
                                'width' => '100%',
                                'allowClear' => 'true',
                                'placeholder' => __('-- Select --')
                            ],
                            'pre_selected'=>route('tour.admin.category.category.getForSelect2',['pre_selected'=>1])
                        ],
                        [
                            'id'    => 'image_id',
                            'type'  => 'uploader',
                            'label' => __('Image Background')
                        ],
                    ]
                ],
            ],
            'category'=>__("Service Tour")
        ];
    }

    public function getTitle()
    {
        return __('Tour: Box Category');
    }

    public function render()
    {
        $model = [
            'title' => $this->title,
            'desc' => $this->desc,
            'list_item' => $this->list_item,
        ];
        if(!empty($this->list_item)){
            $ids = collect($this->list_item)->pluck('category_id');
            $categories = TourCategory::query()->whereIn("id",$ids)->where('status','publish')->get();
            $model['categories'] = $categories;
        }


        return $this->view('Tour::frontend.blocks.box-category-tour.index', $model);
    }

    public function contentAPI($model = []){
        if(!empty($model['list_item'])){
            foreach ( $model['list_item'] as &$item ){
                $item['image_id_url'] = FileHelper::url($item['image_id'], 'full');
            }
        }
        return $model;
    }
}
