<?php


    namespace Modules\Flight\Models;


    use App\BaseModel;
    use Illuminate\Database\Eloquent\Factories\HasFactory;
    use Illuminate\Database\Eloquent\SoftDeletes;
    use Modules\Flight\Factories\FlightSeatFactory;

    class FlightSeat extends BaseModel
    {
        use SoftDeletes;
        use HasFactory;

        protected $table = 'bc_flight_seat';
        protected $fillable=['seat_type','flight_id','price','max_passengers','person','baggage_check_in','baggage_cabin'];

        public function flight()
        {
            return $this->belongsTo(Flight::class,'flight_id')->withDefault();
        }
        public function seatType(){
            return $this->belongsTo(SeatType::class,'seat_type','code')->withDefault();
        }

        protected static function newFactory()
        {
            return FlightSeatFactory::new();
        }
        public function save(array $options = [])
        {
            $save =  parent::save($options); // TODO: Change the autogenerated stub
            if($save){
                $min_price = self::where('flight_id',$this->flight_id)->get()->min('price');
                $flight= $this->flight;
                if($min_price < $flight->min_price or empty($flight->min_price)){
                    $flight->min_price = $min_price;
                    $flight->save();
                }
            }
            return $save;
        }

    }
