<div class="row">
    <div class="col-sm-4">
        <h3 class="form-group-title">{{ __('Page Search') }}</h3>
        <p class="form-group-desc">{{ __('Config page search of your website') }}</p>
    </div>
    <div class="col-sm-8">
        <div class="panel">
            <div class="panel-title"><strong>{{ __('General Options') }}</strong></div>
            <div class="panel-body">
                <div class="form-group">
                    <label class="">{{ __('Title Page') }}</label>
                    <div class="form-controls">
                        <input type="text" name="course_page_search_title"
                            value="{{ setting_item_with_lang('course_page_search_title', request()->query('lang')) }}"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group">
                    <label class="">{{ __('Sub Title Page') }}</label>
                    <div class="form-controls">
                        <input type="text" name="course_page_search_sub_title"
                            value="{{ setting_item_with_lang('course_page_search_sub_title', request()->query('lang')) }}"
                            class="form-control">
                    </div>
                </div>
                @if (is_default_lang())
                    <div class="form-group">
                        <label class="">{{ __('Layout Search') }}</label>
                        <div class="form-controls">
                            <select name="course_layout_search" class="form-control">
                                <option value="style-1"
                                    {{ ($settings['course_layout_search'] ?? '') == 'style-1' ? 'selected' : '' }}>
                                    {{ __('Style 1') }}</option>
                                <option value="style-2"
                                    {{ ($settings['course_layout_search'] ?? '') == 'style-2' ? 'selected' : '' }}>
                                    {{ __('Style 2') }}</option>
                            </select>
                        </div>
                    </div>
                @endif

                {!! do_action(Modules\Course\Hook::COURSE_SETTING_AFTER_LAYOUT_SEARCH) !!}
            </div>
        </div>

        @include('Course::admin.settings.form-search')

        <div class="panel">
            <div class="panel-title"><strong>{{ __('SEO Options') }}</strong></div>
            <div class="panel-body">
                <div class="form-group">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#seo_1">{{ __('General Options') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#seo_2">{{ __('Share Facebook') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#seo_3">{{ __('Share Twitter') }}</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="seo_1">
                            <div class="form-group">
                                <label class="control-label">{{ __('Seo Title') }}</label>
                                <input type="text" name="course_page_list_seo_title" class="form-control"
                                    placeholder="{{ __('Enter title...') }}"
                                    value="{{ setting_item_with_lang('course_page_list_seo_title', request()->query('lang')) }}">
                            </div>
                            <div class="form-group">
                                <label class="control-label">{{ __('Seo Description') }}</label>
                                <input type="text" name="course_page_list_seo_desc" class="form-control"
                                    placeholder="{{ __('Enter description...') }}"
                                    value="{{ setting_item_with_lang('course_page_list_seo_desc', request()->query('lang')) }}">
                            </div>
                            @if (is_default_lang())
                                <div class="form-group form-group-image">
                                    <label class="control-label">{{ __('Featured Image') }}</label>
                                    {!! \Modules\Media\Helpers\FileHelper::fieldUpload(
                                        'course_page_list_seo_image',
                                        $settings['course_page_list_seo_image'] ?? '',
                                    ) !!}
                                </div>
                            @endif
                        </div>
                        @php
                            $seo_share = json_decode(
                                setting_item_with_lang('course_page_list_seo_desc', request()->query('lang'), '[]'),
                                true,
                            );
                        @endphp
                        <div class="tab-pane" id="seo_2">
                            <div class="form-group">
                                <label class="control-label">{{ __('Facebook Title') }}</label>
                                <input type="text" name="course_page_list_seo_share[facebook][title]"
                                    class="form-control" placeholder="{{ __('Enter title...') }}"
                                    value="{{ $seo_share['facebook']['title'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label class="control-label">{{ __('Facebook Description') }}</label>
                                <input type="text" name="course_page_list_seo_share[facebook][desc]"
                                    class="form-control" placeholder="{{ __('Enter description...') }}"
                                    value="{{ $seo_share['facebook']['desc'] ?? '' }}">
                            </div>
                            @if (is_default_lang())
                                <div class="form-group form-group-image">
                                    <label class="control-label">{{ __('Facebook Image') }}</label>
                                    {!! \Modules\Media\Helpers\FileHelper::fieldUpload(
                                        'course_page_list_seo_share[facebook][image]',
                                        $seo_share['facebook']['image'] ?? '',
                                    ) !!}
                                </div>
                            @endif
                        </div>
                        <div class="tab-pane" id="seo_3">
                            <div class="form-group">
                                <label class="control-label">{{ __('Twitter Title') }}</label>
                                <input type="text" name="course_page_list_seo_share[twitter][title]"
                                    class="form-control" placeholder="{{ __('Enter title...') }}"
                                    value="{{ $seo_share['twitter']['title'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label class="control-label">{{ __('Twitter Description') }}</label>
                                <input type="text" name="course_page_list_seo_share[twitter][desc]"
                                    class="form-control" placeholder="{{ __('Enter description...') }}"
                                    value="{{ $seo_share['twitter']['title'] ?? '' }}">
                            </div>
                            @if (is_default_lang())
                                <div class="form-group form-group-image">
                                    <label class="control-label">{{ __('Twitter Image') }}</label>
                                    {!! \Modules\Media\Helpers\FileHelper::fieldUpload(
                                        'course_page_list_seo_share[twitter][image]',
                                        $seo_share['twitter']['image'] ?? '',
                                    ) !!}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if (is_default_lang())
    <hr>
    <div class="row">
        <div class="col-sm-4">
            <h3 class="form-group-title">{{ __('Review Options') }}</h3>
            <p class="form-group-desc">{{ __('Config review for course') }}</p>
        </div>
        <div class="col-sm-8">
            <div class="panel">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="">{{ __('Enable review system for Course?') }}</label>
                        <div class="form-controls">
                            <label><input type="checkbox" name="course_enable_review" value="1"
                                    @if (!empty($settings['course_enable_review'])) checked @endif />
                                {{ __('Yes, please enable it') }} </label>
                            <br>
                            <small
                                class="form-text text-muted">{{ __('Turn on the mode for reviewing course') }}</small>
                        </div>
                    </div>
                    <div class="form-group" data-condition="course_enable_review:is(1)">
                        <label class="">{{ __('Customer must book a course before writing a review?') }}</label>
                        <div class="form-controls">
                            <label><input type="checkbox" name="course_enable_review_after_booking" value="1"
                                    @if (!empty($settings['course_enable_review_after_booking'])) checked @endif /> {{ __('Yes please') }} </label>
                            <br>
                            <small
                                class="form-text text-muted">{{ __('ON: Only post a review after booking - Off: Post review without booking') }}</small>
                        </div>
                    </div>
                    <div class="form-group" data-condition="course_enable_review:is(1)">
                        <label class="">{{ __('Review must be approval by admin') }}</label>
                        <div class="form-controls">
                            <label><input type="checkbox" name="course_review_approved" value="1"
                                    @if (!empty($settings['course_review_approved'])) checked @endif /> {{ __('Yes please') }} </label>
                            <br>
                            <small
                                class="form-text text-muted">{{ __('ON: Review must be approved by admin - OFF: Review is automatically approved') }}</small>
                        </div>
                    </div>
                    <div class="form-group" data-condition="course_enable_review:is(1)">
                        <label class="">{{ __('Review number per page') }}</label>
                        <div class="form-controls">
                            <input type="number" class="form-control" name="course_review_number_per_page"
                                value="{{ $settings['course_review_number_per_page'] ?? 5 }}" />
                            <small class="form-text text-muted">{{ __('Break comments into pages') }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif

@if (is_default_lang())
    <hr>
    <div class="row">
        <div class="col-sm-4">
            <h3 class="form-group-title">{{ __('Booking Buyer Fees Options') }}</h3>
            <p class="form-group-desc">{{ __('Config buyer fees for course') }}</p>
        </div>
        <div class="col-sm-8">
            <div class="panel">
                <div class="panel-body">
                    <div class="form-group-item">
                        <label class="control-label">{{ __('Buyer Fees') }}</label>
                        <div class="g-items-header">
                            <div class="row">
                                <div class="col-md-5">{{ __('Name') }}</div>
                                <div class="col-md-3">{{ __('Price') }}</div>
                                <div class="col-md-3">{{ __('Type') }}</div>
                                <div class="col-md-1"></div>
                            </div>
                        </div>
                        <div class="g-items">
                            <?php $languages = \Modules\Language\Models\Language::getActive(); ?>
                            @if (!empty($settings['course_booking_buyer_fees']))
                                <?php $course_booking_buyer_fees = json_decode($settings['course_booking_buyer_fees'], true); ?>
                                @foreach ($course_booking_buyer_fees as $key => $buyer_fee)
                                    <div class="item" data-number="{{ $key }}">
                                        <div class="row">
                                            <div class="col-md-5">
                                                @if (!empty($languages) && setting_item('site_enable_multi_lang') && setting_item('site_locale'))
                                                    @foreach ($languages as $language)
                                                        <?php $key_lang = setting_item('site_locale') != $language->locale ? '_' . $language->locale : ''; ?>
                                                        <div class="g-lang">
                                                            <div class="title-lang">{{ $language->name }}</div>
                                                            <input type="text"
                                                                name="course_booking_buyer_fees[{{ $key }}][name{{ $key_lang }}]"
                                                                class="form-control"
                                                                value="{{ $buyer_fee['name' . $key_lang] ?? '' }}"
                                                                placeholder="{{ __('Fee name') }}">
                                                            <input type="text"
                                                                name="course_booking_buyer_fees[{{ $key }}][desc{{ $key_lang }}]"
                                                                class="form-control"
                                                                value="{{ $buyer_fee['desc' . $key_lang] ?? '' }}"
                                                                placeholder="{{ __('Fee desc') }}">
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <input type="text"
                                                        name="course_booking_buyer_fees[{{ $key }}][name]"
                                                        class="form-control" value="{{ $buyer_fee['name'] ?? '' }}"
                                                        placeholder="{{ __('Fee name') }}">
                                                    <input type="text"
                                                        name="course_booking_buyer_fees[{{ $key }}][desc]"
                                                        class="form-control" value="{{ $buyer_fee['desc'] ?? '' }}"
                                                        placeholder="{{ __('Fee desc') }}">
                                                @endif
                                            </div>
                                            <div class="col-md-3">
                                                <input type="number" min="0"
                                                    name="course_booking_buyer_fees[{{ $key }}][price]"
                                                    class="form-control" value="{{ $buyer_fee['price'] }}">
                                            </div>
                                            <div class="col-md-3">
                                                <select name="course_booking_buyer_fees[{{ $key }}][type]"
                                                    class="form-control">
                                                    <option @if ($buyer_fee['type'] == 'one_time') selected @endif
                                                        value="one_time">{{ __('One-time') }}</option>
                                                </select>
                                            </div>
                                            <div class="col-md-1">
                                                <span class="btn btn-danger btn-sm btn-remove-item"><i
                                                        class="fa fa-trash"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <div class="text-right">
                            <span class="btn btn-info btn-sm btn-add-item"><i
                                    class="icon ion-ios-add-circle-outline"></i> {{ __('Add item') }}</span>
                        </div>
                        <div class="g-more hide">
                            <div class="item" data-number="__number__">
                                <div class="row">
                                    <div class="col-md-5">
                                        @if (!empty($languages) && setting_item('site_enable_multi_lang') && setting_item('site_locale'))
                                            @foreach ($languages as $language)
                                                <?php $key = setting_item('site_locale') != $language->locale ? '_' . $language->locale : ''; ?>
                                                <div class="g-lang">
                                                    <div class="title-lang">{{ $language->name }}</div>
                                                    <input type="text"
                                                        __name__="course_booking_buyer_fees[__number__][name{{ $key }}]"
                                                        class="form-control" value=""
                                                        placeholder="{{ __('Fee name') }}">
                                                    <input type="text"
                                                        __name__="course_booking_buyer_fees[__number__][desc{{ $key }}]"
                                                        class="form-control" value=""
                                                        placeholder="{{ __('Fee desc') }}">
                                                </div>
                                            @endforeach
                                        @else
                                            <input type="text"
                                                __name__="course_booking_buyer_fees[__number__][name]"
                                                class="form-control" value=""
                                                placeholder="{{ __('Fee name') }}">
                                            <input type="text"
                                                __name__="course_booking_buyer_fees[__number__][desc]"
                                                class="form-control" value=""
                                                placeholder="{{ __('Fee desc') }}">
                                        @endif
                                    </div>
                                    <div class="col-md-3">
                                        <input type="number" min="0"
                                            __name__="course_booking_buyer_fees[__number__][price]"
                                            class="form-control" value="">
                                    </div>
                                    <div class="col-md-3">
                                        <select __name__="course_booking_buyer_fees[__number__][type]"
                                            class="form-control">
                                            <option value="one_time">{{ __('One-time') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-1">
                                        <span class="btn btn-danger btn-sm btn-remove-item"><i
                                                class="fa fa-trash"></i></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@if (is_default_lang())
    <hr>
    <div class="row">
        <div class="col-sm-4">
            <h3 class="form-group-title">{{ __('Teacher Options') }}</h3>
            <p class="form-group-desc">{{ __('Teacher config for course') }}</p>
        </div>
        <div class="col-sm-8">
            <div class="panel">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="">{{ __('Job created by vendor must be approved by admin') }}</label>
                        <div class="form-controls">
                            <label><input type="checkbox" name="course_teacher_create_service_must_approved_by_admin"
                                    value="1" @if (!empty($settings['course_teacher_create_service_must_approved_by_admin'])) checked @endif />
                                {{ __('Yes please') }} </label>
                            <br>
                            <small
                                class="form-text text-muted">{{ __('ON: When vendor posts a service, it needs to be approved by administrator') }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif


@if (is_default_lang())
    <hr>
    <div class="row">
        <div class="col-sm-4">
            <h3 class="form-group-title">{{ __('Disable course module?') }}</h3>
        </div>
        <div class="col-sm-8">
            <div class="panel">
                <div class="panel-title"><strong>{{ __('Disable course module') }}</strong></div>
                <div class="panel-body">
                    <div class="form-group">
                        <div class="form-controls">
                            <label><input type="checkbox" name="course_disable" value="1"
                                    @if (setting_item('course_disable')) checked @endif>
                                {{ __('Yes, please disable it') }}</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
