<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('bc_review')) {
            Schema::create('bc_review', function (Blueprint $table) {
                $table->bigIncrements('id');

                $table->integer('object_id')->nullable();
                $table->string('object_model', 255)->nullable();
                $table->string('title', 255)->nullable();
                $table->text('content')->nullable();
            $table->integer('rate_number')->nullable();
                $table->string('author_ip', 100)->nullable();
                $table->bigInteger('object_author_id')->nullable();
                $table->bigInteger('author_id')->nullable();
                $table->string('status', 50)->nullable();
                $table->dateTime('publish_date')->nullable();
                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();
                $table->softDeletes();

                $table->index(['object_model', 'object_id']);
                $table->index(['object_author_id']);

                //Languages
                $table->string('lang', 10)->nullable();

                $table->timestamps();
            });
        }


        if (!Schema::hasTable('bc_review_meta')) {
            Schema::create('bc_review_meta', function (Blueprint $table) {
                $table->bigIncrements('id');

                $table->integer('review_id')->nullable();
                $table->integer('object_id')->nullable();
                $table->string('object_model', 255)->nullable();
                $table->string('name', 255)->nullable();
                $table->text('val')->nullable();

                $table->integer('create_user')->nullable();
                $table->integer('update_user')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bc_review');
        Schema::dropIfExists('bc_review_meta');
    }
};
